/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;

class VWStepAttribute {
    protected static final String TRUE = "true";
    private String m_name = null;
    private int m_nType = 4;
    private boolean m_bIsArray = false;
    private Object m_value = this.getDefaultValue(this.m_nType, this.m_bIsArray);

    public VWStepAttribute() {
    }

    public VWStepAttribute(String name, int nType, boolean bIsArray, Object value) {
        this.m_name = name;
        this.m_nType = nType;
        this.m_bIsArray = bIsArray;
        this.m_value = value;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name, VWMapNode vwMapNode) {
        Object oldValue = this.m_value;
        this.m_value = null;
        this.updateAttributeInfo(vwMapNode);
        this.m_name = name;
        this.m_value = oldValue;
        this.updateAttributeInfo(vwMapNode);
    }

    public int getType() {
        return this.m_nType;
    }

    public String getTypeString() {
        try {
            String typeStr = VWFieldType.getLocalizedString(this.m_nType);
            if (this.m_bIsArray) {
                typeStr = typeStr + "[ ]";
            }
            return typeStr;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void setType(int nType, boolean bIsArray, VWMapNode vwMapNode) {
        this.m_nType = nType;
        this.m_bIsArray = bIsArray;
        this.m_value = this.getDefaultValue(this.m_nType, this.m_bIsArray);
        this.updateAttributeInfo(vwMapNode);
    }

    public boolean isArray() {
        return this.m_bIsArray;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value, VWMapNode vwMapNode) {
        this.m_value = value;
        this.updateAttributeInfo(vwMapNode);
    }

    public String toString() {
        return this.m_name;
    }

    private Object getDefaultValue(int nType, boolean bIsArray) {
        try {
            if (bIsArray) {
                switch (nType) {
                    case 4: {
                        Boolean[] array = new Boolean[]{new Boolean(TRUE)};
                        return array;
                    }
                    case 8: {
                        Double[] array = new Double[]{new Double(0.0)};
                        return array;
                    }
                    case 1: {
                        Integer[] array = new Integer[]{new Integer(0)};
                        return array;
                    }
                    case 2: {
                        String[] array = new String[]{new String("")};
                        return array;
                    }
                }
            } else {
                switch (nType) {
                    case 4: {
                        return new Boolean(TRUE);
                    }
                    case 8: {
                        return new Double(0.0);
                    }
                    case 1: {
                        return new Integer(0);
                    }
                    case 2: {
                        return new String("");
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void updateAttributeInfo(VWMapNode mapNode) {
        try {
            if (mapNode != null && this.m_name != null) {
                VWAttributeInfo attributeInfo = mapNode.getAttributeInfo();
                if (attributeInfo == null) {
                    attributeInfo = new VWAttributeInfo();
                } else if (attributeInfo.getFieldValue(this.m_name) != null) {
                    attributeInfo.deleteField(this.m_name);
                }
                attributeInfo.setFieldValue(this.m_name, this.m_value);
                mapNode.setAttributeInfo(attributeInfo);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

